<?php
require_once __DIR__ . '/../utils/Config.php'; require_once SRC_PATH . '/models/AnonChat.php'; require_once SRC_PATH . '/classes/Database.php'; class AnonChatController { private $db; public function __construct() { $this->db = Database::getInstance(); try { $tableExists = $this->db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='game_state_meta'")->fetchColumn(); if (!$tableExists) { $this->db->query("CREATE TABLE IF NOT EXISTS game_state_meta (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    key_name TEXT NOT NULL UNIQUE,
                    value TEXT NOT NULL,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                )"); } $exists = $this->db->query( "SELECT COUNT(*) FROM game_state_meta WHERE key_name = 'last_reported_unread_count'" )->fetchColumn(); if (!$exists) { $this->db->query( "INSERT INTO game_state_meta (key_name, value) VALUES ('last_reported_unread_count', '0')" ); } } catch (Exception $e) { } } public function getAllMessages() { return AnonChat::getAll($this->db); } public function getUnreadMessages() { return AnonChat::getUnread($this->db); } public function countUnreadMessages() { return AnonChat::countUnread($this->db); } public function getMessage($id) { return AnonChat::getById($this->db, $id); } public function markMessageAsRead($id) { $message = $this->getMessage($id); if ($message) { $message->markAsRead(); $message->save($this->db); $this->setLastReportedUnreadCount(0); return true; } return false; } public function checkForNewMessages($currentYear, $currentMonth) { $messages = AnonChat::checkForNewMessages($this->db, $currentYear, $currentMonth); return $messages; } public function addMessage($title, $message, $triggerType, $triggerCondition = null, $year = null, $month = null, $folder = 'inbox', $metadata = null) { $this->setLastReportedUnreadCount(0); return AnonChat::addMessage( $this->db, $title, $message, $triggerType, $triggerCondition, $year, $month, $folder, $metadata ); } private function getLastReportedUnreadCount() { $result = $this->db->query( "SELECT value FROM game_state_meta WHERE key_name = 'last_reported_unread_count'" )->fetch(PDO::FETCH_ASSOC); return $result ? intval($result['value']) : 0; } private function setLastReportedUnreadCount($count) { $exists = $this->db->query( "SELECT COUNT(*) FROM game_state_meta WHERE key_name = 'last_reported_unread_count'" )->fetchColumn(); if ($exists) { $this->db->query( "UPDATE game_state_meta SET value = ? WHERE key_name = 'last_reported_unread_count'", [$count] ); } else { $this->db->query( "INSERT INTO game_state_meta (key_name, value) VALUES ('last_reported_unread_count', ?)", [$count] ); } } public function addUnreadMessagesEvent() { $unreadCount = $this->countUnreadMessages(); $lastReportedCount = $this->getLastReportedUnreadCount(); if ($unreadCount > 0 && $unreadCount != $lastReportedCount) { $eventMessage = $unreadCount == 1 ? t('game.events.unread_messages_single') : t('game.events.unread_messages_multiple', ['count' => $unreadCount]); $this->broadcastEvent('info', $eventMessage, date('H:i')); $this->setLastReportedUnreadCount($unreadCount); return $unreadCount; } return 0; } private function addEventLog($type, $message) { $time = date('H:i'); $this->db->query( "INSERT INTO event_log (type, message, event_time) VALUES (?, ?, ?)", [$type, $message, $time] ); $this->broadcastEvent($type, $message, $time); } private function broadcastEvent($type, $message, $time) { if (!isset($_SESSION['pending_events'])) { $_SESSION['pending_events'] = []; } $_SESSION['pending_events'][] = [ 'type' => $type, 'message' => $message, 'event_time' => $time ]; } public function moveMessageToFolder($id, $folder) { $message = $this->getMessage($id); if ($message) { $message->moveToFolder($folder); $message->save($this->db); return true; } return false; } public function getMessagesInFolder($folder) { $query = "SELECT * FROM anonchat_messages WHERE folder = ? ORDER BY created_at DESC"; $result = $this->db->query($query, [$folder]); $messages = []; while ($message = $result->fetch(PDO::FETCH_ASSOC)) { $messages[] = new AnonChat($message); } return $messages; } public function checkForMissionMessages($currentYear, $currentMonth, $missionController) { $db = Database::getInstance(); $missions = $missionController->getAvailableMissions($currentYear, $currentMonth); $newMessages = []; foreach ($missions as $mission) { $existingMessage = $db->query( "SELECT COUNT(*) FROM anonchat_messages
                 WHERE metadata LIKE ?", ["%\"mission_id\":" . $mission->getId() . "%"] )->fetchColumn(); if ($existingMessage == 0) { $messageId = $missionController->addMissionMessage($mission, $this); if ($messageId) { $newMessages[] = $this->getMessage($messageId); } } } return $newMessages; } } 